const express = require('express');
const router = express.Router();
const importController = require('../controllers/import.controller');
const exportController = require('../controllers/export.controller');
const insertController = require('../controllers/insert.controller');

// Ruta para exportar datos de paciente
router.get('/exportpaciente', exportController.exportDataPaciente);

// Ruta para exportar datos de usuario
router.get('/exportusuario', exportController.exportDataUsuario);

// Ruta para exportar datos de agendamiento
router.get('/exportagendamiento', exportController.exportDataAgendamiento);

// Ruta para exportar datos de agendamiento
router.get('/exportauditoria', exportController.exportDataAuditoria);

// Ruta para importar datos paciente
router.post('/importpaciente', importController.importDataPaciente);

// Ruta para importar datos usuario
router.post('/importusuario', importController.importDataUsuario);

// Ruta para importar datos agendamiento
router.post('/importagendamiento', importController.importDataAgendamiento);

// Ruta para importar datos agendamiento
router.post('/importauditoria', importController.importDataAuditoria);

// Ruta para importar datos agendamiento
router.get('/insert', insertController.insertData);

insertController

module.exports = router;