const express = require("express");
const autenticacionController = require("../controllers/autenticacion.controller");
const { loginLimiter } = require("../middlewares/rateLimit.middleware");
const {verifyToken} = require('../middlewares/auth.middleware'); // Importar middleware

const router = express.Router();
/**
 * @swagger
 * components:
 *   schemas:
 *     Authenticacion:
 *       type: object
 *       required:
 *         - Nombre
 *         - Apellido
 *         - Correo
 *         - Celular
 *         - Documento
 *         - Colegiatura
 *         - FechaNacimiento
 *         - Contrasenia
 *         - CodigoVerificacion
 *         - Foto
 *         - TipoDocumentoId
 *         - GeneroId
 *         - TipoUsuarioId
 *         - EstadoId
 *         - vinculacionId
 *         - SedeId
 *       properties:
 *         id:
 *           type: number
 *           description: El identificador único del Usuario
 *         Nombre:
 *           type: string
 *           description: Nombre del Usuario
 *         Apellido:
 *           type: string
 *           description: Apellido del Usuario
 *         Correo:
 *           type: string
 *           description: Correo del Usuario
 *         Celular:
 *           type: string
 *           description: Celular del Usuario
 *         Documento:
 *           type: string
 *           description: Documento del Usuario
 *         Colegiatura:
 *           type: string
 *           description: Colegiatura del Usuario (solo si corresponde)
 *         FechaNacimiento:
 *           type: Date
 *           description: Fecha Nacimiento del Usuario
 *         Contrasenia:
 *           type: string
 *           description: Contrasenia del Usuario
 *         CodigoVerificacion:
 *           type: number
 *           description: Codigo Verificacion del Usuario para actualizar la contrasenia
 *         Foto:
 *           type: string
 *           description: Foto del Usuario
 *         TipoDocumentoId:
 *           type: number
 *           description: Tipo Documento del Usuario
 *         GeneroId:
 *           type: number
 *           description: Genero del Usuario
 *         TipoUsuarioId:
 *           type: number
 *           description:  Tipo Usuario del Usuario
 *         EstadoId:
 *           type: number
 *           description:  Estado del Usuario para recuperar contrasenia
 *         VinculacionId:
 *           type: number
 *           description: vinculacion del Usuario con la empresa
 *         SedeId:
 *           type: number
 *           description: Sede del Usuario
 *       example:
 *         id: "1"
 *         Nombre: "Anibal Jhamil"
 *         Apellido: "Huaman Verastein"
 *         Correo: "anibaljhamil@gmail.com"
 *         Celular: "958899251"
 *         Documento: "72547410"
 *         Colegiatura: "nop"
 *         FechaNacimiento: "11/04/1997"
 *         Contrasenia: "wasaaaaa"
 *         CodigoVerificacion: "ads"
 *         Foto: "ninguna"
 *         GeneroId: "1"
 *         TipoUsuarioId: "1"
 *         EstadoId: "2"
 *         VinculacionId: "2"
 *         SedeId: "1"
 */
/**
/**
 * @swagger
 * tags:
 *   name: Authenticacion
 *   description: API para gestionar Authenticacion
 */
/**
/**
 * @swagger
 * /pilar/autenticacion/recover-password/{id}:
 *   put:
 *     summary: Obtiene un Usuario por id
 *     tags: [Authenticacion]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *         required: true
 *         description: ID del usuario
 *       - in: body
 *         name: contraseniaActual
 *         schema:
 *           type: string
 *         required: true
 *         description: contrasenia Actual
 *       - in: body
 *         name: nuevaContrasenia
 *         schema:
 *           type: string
 *         required: true
 *         description: nueva Contrasenia
 *     responses:
 *       200:
 *         description: Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Usuario'
 *       404:
 *         description: Usuario no encontrado.
 */
// 🔑 Ruta para actualizar solo la contraseña
router.put("/recover-password/:id", verifyToken, autenticacionController.updatePassword);
/**
 * @swagger
 * /pilar/autenticacion/logincorreo:
 *   post:
 *     summary: Obtiene un Usuario por consultorio
 *     tags: [Authenticacion]
 *     parameters:
 *       - in: body
 *         name: correo
 *         schema:
 *           type: string
 *         required: true
 *         description: correo del Usuario
 *       - in: body
 *         name: contrasenia
 *         schema:
 *           type: string
 *         required: true
 *         description: contrasenia del Usuario
 *     responses:
 *       200:
 *         description: Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Usuario'
 *       404:
 *         description: Usuario no encontrado.
 */
router.post("/logincorreo", loginLimiter, verifyToken, autenticacionController.logincorreo); // Aplica limitador
/**
 * @swagger
 * /pilar/autenticacion/logincelular:
 *   post:
 *     summary: Obtiene un Usuario por consultorio
 *     tags: [Authenticacion]
 *     parameters:
 *       - in: body
 *         name: celular
 *         schema:
 *           type: string
 *         required: true
 *         description: celular del Usuario
 *       - in: body
 *         name: contrasenia
 *         schema:
 *           type: string
 *         required: true
 *         description: contrasenia del Usuario
 *     responses:
 *       200:
 *         description: Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Usuario'
 *       404:
 *         description: Usuario no encontrado.
 */
router.post("/logincelular", loginLimiter, verifyToken, autenticacionController.logincelular); // Aplica limitador
/**
 * @swagger
 * /pilar/autenticacion/generar-codigo:
 *   post:
 *     summary: Obtiene la generacion de un codigo por medio del correo del usuario
 *     tags: [Authenticacion]
 *     parameters:
 *       - in: body
 *         name: correo
 *         schema:
 *           type: string
 *         required: true
 *         description: correo del Usuario
 *     responses:
 *       200:
 *         description: Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Usuario'
 *       404:
 *         description: Usuario no encontrado.
 */
// Nueva ruta para generar código de verificación
router.post("/generar-codigo", verifyToken, autenticacionController.generarCodigoVerificacion);
/**
 * @swagger
 * /pilar/autenticacion/verificar-codigo:
 *   post:
 *     summary: Verifica el codigo del Usuario
 *     tags: [Authenticacion]
 *     parameters:
 *       - in: body
 *         name: correo
 *         schema:
 *           type: string
 *         required: true
 *         description: correo del Usuario
 *       - in: body
 *         name: codigoverificacion
 *         schema:
 *           type: string
 *         required: true
 *         description: codigo verificacion del Usuario
 *     responses:
 *       200:
 *         description: Usuario encontrado.
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Usuario'
 *       404:
 *         description: Usuario no encontrado.
 */
// Nueva ruta para verificar código
router.post("/verificar-codigo", verifyToken, autenticacionController.verificarCodigo);

module.exports = router;
