const express = require('express');
const router = express.Router();
const {verifyToken} = require('../middlewares/auth.middleware'); // Importar middleware
const AuditoriaController = require('../controllers/auditoria.controller');

// Rutas CRUD básicas
router.post('/create', verifyToken, AuditoriaController.create);
router.get('/', verifyToken, AuditoriaController.getAll);
router.get('/:id', verifyToken, AuditoriaController.getById);
router.put('/update/:id', verifyToken, AuditoriaController.update);
router.delete('/:id', verifyToken, AuditoriaController.delete);

// Rutas específicas
router.get('/user/:userId', verifyToken, AuditoriaController.getByUser);
router.get('/table/:tableName', verifyToken, AuditoriaController.getByTable);

module.exports = router;