const { Sequelize } = require('sequelize');
require('dotenv').config();

const sequelize = new Sequelize(process.env.DB_URL);

const Usuario = require('./usuario.model')(sequelize);
const Paciente = require('./paciente.model')(sequelize);
const Ubicacion = require('./ubicacion.model')(sequelize);
const Agendamiento = require('./agendamiento.model')(sequelize);
const Familiar = require('./familiar.model')(sequelize);
const Covertura = require('./covertura.model')(sequelize);
const Atiende = require('./atiende.model')(sequelize);
const Auditoria = require('./auditoria.model')(sequelize);

// Definir relaciones
// relacion Paciente ➡️ Familiar
Paciente.hasMany(Familiar);
Familiar.belongsTo(Paciente);
// relacion Paciente ➡️ Covertura
Paciente.hasMany(Covertura);
Covertura.belongsTo(Paciente);
// relacion Usuario ➡️ Atiende
Usuario.hasMany(Atiende);
Atiende.belongsTo(Usuario);
// relacion Paciente ➡️ Ubicacion
Paciente.hasMany(Ubicacion);
Ubicacion.belongsTo(Paciente);
// relacion Usuario ➡️ Ubicacion
Usuario.hasMany(Familiar);
Ubicacion.belongsTo(Usuario);
// relacion Paciente ➡️ Agendamiento
Paciente.hasMany(Agendamiento);
Agendamiento.belongsTo(Paciente);
// relacion Usuario ➡️ Agendamiento
Usuario.hasMany(Agendamiento);
Agendamiento.belongsTo(Usuario);
// relacion Usuario ➡️ Auditoria
Usuario.hasMany(Auditoria);
Auditoria.belongsTo(Usuario);

// Exportar modelos y conexión
module.exports = { sequelize, 
    Usuario, 
    Paciente, 
    Ubicacion, 
    Agendamiento, 
    Familiar, 
    Covertura, 
    Atiende,
    Auditoria};
