const {
    DataTypes
} = require('sequelize');

module.exports = (sequelize) => {
    return sequelize.define('Agendamiento', {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        FechayHoraInicio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        FechayHoraFin: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Detalles: {
            type: DataTypes.STRING,
            allowNull: false
        },
        Referidopor: {
            type: DataTypes.STRING,
            allowNull: false
        },
        PacienteAgendado: {
            type: DataTypes.STRING,
            allowNull: false
        },
        OdontologoAsignado: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SedeNombre: {
            type: DataTypes.STRING,
            allowNull: false
        },
        SedeIdentificador: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Servicio: {
            type: DataTypes.STRING,
            allowNull: false
        },
        UsuarioIdentificador: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        Estado: {
            type: DataTypes.STRING,
            allowNull: false
        },
        EstadoCitaId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        EstadoPagoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        TipoPagoId: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        PacienteId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Pacientes',
                key: 'id'
            }
        },
        OdontologoId: {
            type: DataTypes.INTEGER,
            references: {
                model: 'Usuarios',
                key: 'id'
            }
        }
        
    });
}