const { body, validationResult } = require("express-validator");

exports.validatePerson = [
  body("Nombre").notEmpty().withMessage("El nombre es obligatorio"),
  body("Apellido").notEmpty().withMessage("El apellido es obligatorio"),
  body("Correo").isEmail().withMessage("Debe ser un correo válido"),
  body("Celular")
    .isLength({ min: 9, max: 9 })
    .withMessage("El numero debe tener 9 caracteres"),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    next();
  },
];

exports.validatePaciente = [
  body("Nombres").notEmpty().withMessage("El nombre es obligatorio"),
  body("Apellidos").notEmpty().withMessage("El apellido es obligatorio"),
  body("Correo").isEmail().withMessage("Debe ser un correo válido"),
  body("Celular")
    .isLength({ min: 9, max: 9 })
    .withMessage("El numero debe tener 9 caracteres"),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({ errors: errors.array() });
    }
    next();
  },
];
