const rateLimit = require("express-rate-limit");

// Limitar intentos de login (máx. 5 intentos por IP cada 15 minutos)
exports.loginLimiter = rateLimit({
  windowMs: 15 * 60 * 1000, // 15 minutos
  max: 5, // Máximo 5 intentos
  message: "Demasiados intentos de inicio de sesión, intenta de nuevo más tarde.",
  headers: true,
});
