const { sequelize,
    Usuario, Paciente, Ubicacion, Agendamiento, 
    Familiar, Covertura, Atiende } = require("../models");
  // Datos fijos a insertar
  const usuarios = [
    {
      // usuario ingeinero
      Nombre: 'Anibal Jhamil', Apellido: 'Huaman Verastein',
      Correo: 'anibaljhamil@gmail.com', Celular: '958899251',
      TipoDocumentoId: 1, Documento: '72547410', 
      Colegiatura: '3253251', FechaNacimiento: '1997-04-11',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 2, EstadoId: 1, VinculacionId: 8, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario administrador global
      Nombre: 'Administrador', Apellido: 'Global',
      Correo: 'jxdesignui@gmail.com', Celular: '938811980',
      TipoDocumentoId: 1, Documento: '72547411', 
      Colegiatura: '99999912', FechaNacimiento: '1997-04-11',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 1, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario administrador sede
      Nombre: 'Luis', Apellido: 'Fernández',
      Correo: 'luis.fernández@gmail.com', Celular: '911111111',
      TipoDocumentoId: 1, Documento: '48329787', 
      Colegiatura: 'COL2266', FechaNacimiento: '1979-05-21',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 3, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {// usuario recepcionista
      Nombre: 'Pilar', Apellido: 'Gómez',
      Correo: 'pilar.gomez@gmail.com', Celular: '922222222',
      TipoDocumentoId: 1, Documento: '12028534', 
      Colegiatura: 'COL3559', FechaNacimiento: '1993-11-14',
      GeneroId: 2, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 4, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario asistente
      Nombre: 'Elena', Apellido: 'Díaz',
      Correo: 'elena.díaz@gmail.com', Celular: '933333333',
      TipoDocumentoId: 1, Documento: '46047909', 
      Colegiatura: 'COL1002', FechaNacimiento: '1970-01-06',
      GeneroId: 2, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 5, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario odontologo
      Nombre: 'Miguel', Apellido: 'Ruiz',
      Correo: 'miguel.ruiz@gmail.com', Celular: '944444444',
      TipoDocumentoId: 1, Documento: '49000281', 
      Colegiatura: 'COL2218', FechaNacimiento: '1988-11-01',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 6, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de logistica
      Nombre: 'Francisco', Apellido: 'Martín',
      Correo: 'francisco.martín@gmail.com', Celular: '9555555555',
      TipoDocumentoId: 1, Documento: '69475488', 
      Colegiatura: 'COL7883', FechaNacimiento: '1999-04-24',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 7, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de radiografia
      Nombre: 'Manuel', Apellido: 'Gutiérrez',
      Correo: 'manuel.gutiérrez@gmail.com', Celular: '966666666',
      TipoDocumentoId: 1, Documento: '82366127', 
      Colegiatura: 'COL3349', FechaNacimiento: '1971-09-24',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 8, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de laboratorio
      Nombre: 'Laura', Apellido: 'Díaz',
      Correo: 'laura.díaz@gmail.com', Celular: '977777777',
      TipoDocumentoId: 1, Documento: '52554731', 
      Colegiatura: 'COL9286', FechaNacimiento: '1970-10-02',
      GeneroId: 2, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 9, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de RRHH
      Nombre: 'Pilar', Apellido: 'García',
      Correo: 'pilar.garcía@gmail.com', Celular: '988888888',
      TipoDocumentoId: 1, Documento: '32020644', 
      Colegiatura: 'COL4571', FechaNacimiento: '1981-03-05',
      GeneroId: 2, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 10, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de contabilidad
      Nombre: 'Miguel', Apellido: 'Álvarez',
      Correo: 'miguel.álvarez@gmail.com', Celular: '9999999999',
      TipoDocumentoId: 1, Documento: '45583836', 
      Colegiatura: 'COL9430', FechaNacimiento: '1998-08-22',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 11, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    {
      // usuario de marketing y comunicaciones
      Nombre: 'Antonio', Apellido: 'García',
      Correo: 'antonio.garcía@gmail.com', Celular: '911111112',
      TipoDocumentoId: 1, Documento: '78292738', 
      Colegiatura: 'COL6190', FechaNacimiento: '1992-07-06',
      GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
      TipoUsuarioId: 12, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    },
    // {
    //   // otros usuarios 
    //   Nombre: 'Administrador', Apellido: 'Global',
    //   Correo: 'jxdesignui@gmail.com', Celular: '911111111',
    //   TipoDocumentoId: 1, Documento: '72547411', 
    //   Colegiatura: '99999912', FechaNacimiento: '1997-04-11',
    //   GeneroId: 1, Codigo: 'adfasf', Contrasenia: 'wasa', 
    //   TipoUsuarioId: 1, EstadoId: 1, VinculacionId: 2, SedeId: 1, 
    //   Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png'
    // }
  ]
  const pacientes = [
    {
      Nombres: 'Anibal Jhamil', Apellidos: 'Huaman Verastein',
      Correo: 'anibaljhamil@gmail.com', Celular: '958899251',
      TipoDocumentoId: 1, Documento: '72547410', NroHistoriaClinica: '72547410', 
      FechaNacimiento: '1997-04-11', Ocupacion: 'FreeLancer - Ingeniero', Observacion: 'Ninguna', 
      TipoAfiliacion: 'Titular', FechaAfiliacion: '2025-03-11', IAFAId: 1, 
      GeneroId: 1, GradoInstruccionId: 10, SedeId: 1, FuenteCaptacionId: 1, OdontologoId: 1, 
      Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png',
    }
  ]
  // Método para exportar datos a un archivo JSON
  exports.insertData = async (req, res) => {
    try {
      await sequelize.sync(); // Asegurar que la base de datos está sincronizada
      console.log("📌 Empezando con la Insercion de Datos");
      for (const usuario of usuarios) {
        await Usuario.findOrCreate(
          {
            where: {
              Correo: usuario.Correo,
              Celular: usuario.Celular,
              Documento: usuario.Documento
            },
            defaults: usuario
          }
        );
      }
      console.log("📌 Usuarios insertados correctamente");
      for (const paciente of pacientes) {
        await Paciente.findOrCreate(
          {
            where: {
              Documento: paciente.Documento,
              NroHistoriaClinica: paciente.NroHistoriaClinica,
            },
            defaults: paciente
          }
        );
      }
      console.log("📌 Pacientes insertados correctamente");
      console.log("📌 Inserción de datos completada con éxito!");
      res.status(200).json(
        {
          'message': 'Datos insertados correctamente'
        }
      );
    } catch (error) {
      console.error("❌ Error insertando Datos:", error);
    } finally {
      await sequelize.close(); // Cerrar conexión con la base de datos
    }
  };