const {Covertura} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Coverturaes
exports.getCoverturaAll = async (req, res) => {
  try {
    const coverturas = await Covertura.findAll();
    logger.info("Coverturas obtenidos correctamente");
    res.json(coverturas);
  } catch (error) {
    logger.error("Error al obtener Coverturas: " + error.message);
    res.status(500).json({ error: "Error al obtener Coverturaes" });
  }
};
// Obtener una Covertura ACTIVA por Paciente
exports.getCoverturaActivaByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const coverturas = await Covertura.findAll(
      {
        where: {
          PacienteId: paciente,
          EstadoCovertura: 'activo'
        }
      }
    );
    if (!coverturas) {
      logger.error("Covertura no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Coverturas no encontrada" });
    }
    logger.info("Coverturas obtenidas correctamente por su asociacion con la Empresa");
    res.json(coverturas);
  } catch (error) {
    logger.error("Error al obtener el Covertura mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Coverturas" });
  }
};
// Obtener una Covertura por Paciente
exports.getCoverturaByPaciente = async (req, res) => {
  try {
    const { paciente } = req.params;
    const coverturas = await Covertura.findAll(
      {
        where: {
          PacienteId: paciente
        }
      }
    );
    if (!coverturas) {
      logger.error("Covertura no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Coverturas no encontrada" });
    }
    logger.info("Coverturas obtenidas correctamente por su asociacion con la Empresa");
    res.json(coverturas);
  } catch (error) {
    logger.error("Error al obtener el Covertura mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Coverturas" });
  }
};
// Obtener una Covertura por IAFA
exports.getCoverturaByIAFA = async (req, res) => {
  try {
    const { iafa } = req.params;
    const coverturas = await Covertura.findAll(
      {
        where: {
          IAFAId: iafa
        }
      }
    );
    if (!coverturas) {
      logger.error("Covertura no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Coverturas no encontrada" });
    }
    logger.info("Coverturas obtenidas correctamente por su asociacion con la Empresa");
    res.json(coverturas);
  } catch (error) {
    logger.error("Error al obtener el Covertura mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Coverturas" });
  }
};

// Obtener una Covertura por ID
exports.getCoverturaById = async (req, res) => {
  try {
    const covertura = await Covertura.findByPk(req.params.id);
    if (!covertura) {
      logger.error("Covertura no encontrada por su ID");
      return res.status(404).json({ error: "Covertura no encontrada" });
    }
    logger.info("Covertura obtenido correctamente por su ID");
    res.json(covertura);
  } catch (error) {
    logger.error("Error al obtener el Covertura mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Covertura" });
  }
};

// Crear una Covertura
exports.createCovertura = async (req, res) => {
  try {
    const covertura = await Covertura.create(req.body);
    logger.info("Coverturas creado correctamente");
    res.status(201).json(covertura);
  } catch (error) {
    logger.error("Error al crear un Covertura: " + error.message);
    res.status(500).json({ error: "Error al crear Covertura" });
  }
};

// Actualizar una Covertura
exports.updateCovertura = async (req, res) => {
  try {
    const covertura = await Covertura.findByPk(req.params.id);
    if (!covertura) {
      logger.error("Covertura no encontrada por su ID");
      return res.status(404).json({ error: "Covertura no encontrada" });
    }
    await covertura.update(req.body);
    logger.info("Coverturas actualizado correctamente");
    res.json(covertura);
  } catch (error) {
    logger.error("Error al actualizar un Covertura: " + error.message);
    res.status(500).json({ error: "Error al actualizar Covertura" });
  }
};

// Eliminar una Covertura
exports.deleteCovertura = async (req, res) => {
  try {
    const covertura = await Covertura.findByPk(req.params.id);
    if (!covertura) {
      logger.error("Covertura no encontrada por su ID");
      return res.status(404).json({ error: "Covertura no encontrada" });
    }
    await Covertura.destroy();
    logger.info("Coverturas eliminado correctamente");
    res.json({ message: "Covertura eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Covertura: " + error.message);
    res.status(500).json({ error: "Error al eliminar Covertura" });
  }
};

