const { Auditoria } = require('../models');

const AuditoriaController = {
  // Crear nueva Auditoriaoría
  create: async (req, res) => {
    try {
      const {
        UsuarioId,
        Registroid,
        Accion,
        Tabla,
        Resumen,
        Detalle,
        Interaccion
      } = req.body;

      const newAuditoria = await Auditoria.create({
        UsuarioId,
        Registroid,
        Accion,
        Tabla,
        Resumen,
        Detalle,
        Interaccion: Interaccion || new Date()
      });

      res.status(201).json({
        success: true,
        message: 'Auditoriaoría creada exitosamente',
        data: newAuditoria
      });
    } catch (error) {
      console.error('Error al crear Auditoriaoría:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Obtener todas las Auditoriaorías
  getAll: async (req, res) => {
    try {
      const { page = 1, limit = 10, UsuarioId, Tabla, Accion } = req.query;
      const offset = (page - 1) * limit;

      // Construir filtros dinámicos
      const where = {};
      if (UsuarioId) where.UsuarioId = UsuarioId;
      if (Tabla) where.Tabla = Tabla;
      if (Accion) where.Accion = Accion;

      const Auditorias = await Auditoria.findAndCountAll({
        where,
        limit: parseInt(limit),
        offset: parseInt(offset),
        order: [['createdAt', 'DESC']]
      });

      res.status(200).json({
        success: true,
        data: Auditorias.rows,
        pagination: {
          total: Auditorias.count,
          page: parseInt(page),
          limit: parseInt(limit),
          totalPages: Math.ceil(Auditorias.count / limit)
        }
      });
    } catch (error) {
      console.error('Error al obtener Auditoriaorías:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Obtener Auditoriaoría por ID
  getById: async (req, res) => {
    try {
      const { id } = req.params;

      const Auditoria = await Auditoria.findByPk(id);

      if (!Auditoria) {
        return res.status(404).json({
          success: false,
          message: 'Auditoriaoría no encontrada'
        });
      }

      res.status(200).json({
        success: true,
        data: Auditoria
      });
    } catch (error) {
      console.error('Error al obtener Auditoriaoría:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Actualizar Auditoriaoría
  update: async (req, res) => {
    try {
      const { id } = req.params;
      const {
        UsuarioId,
        Registroid,
        Accion,
        Tabla,
        Resumen,
        Detalle,
        Interaccion
      } = req.body;

      const Auditoria = await Auditoria.findByPk(id);

      if (!Auditoria) {
        return res.status(404).json({
          success: false,
          message: 'Auditoriaoría no encontrada'
        });
      }

      await Auditoria.update({
        UsuarioId,
        Registroid,
        Accion,
        Tabla,
        Resumen,
        Detalle,
        Interaccion
      });

      res.status(200).json({
        success: true,
        message: 'Auditoriaoría actualizada exitosamente',
        data: Auditoria
      });
    } catch (error) {
      console.error('Error al actualizar Auditoriaoría:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Eliminar Auditoriaoría
  delete: async (req, res) => {
    try {
      const { id } = req.params;

      const Auditoria = await Auditoria.findByPk(id);

      if (!Auditoria) {
        return res.status(404).json({
          success: false,
          message: 'Auditoriaoría no encontrada'
        });
      }

      await Auditoria.destroy();

      res.status(200).json({
        success: true,
        message: 'Auditoriaoría eliminada exitosamente'
      });
    } catch (error) {
      console.error('Error al eliminar Auditoriaoría:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Obtener Auditoriaorías por usuario
  getByUser: async (req, res) => {
    try {
      const { userId } = req.params;
      const { page = 1, limit = 10 } = req.query;
      const offset = (page - 1) * limit;

      const Auditorias = await Auditoria.findAndCountAll({
        where: { UsuarioId: userId },
        limit: parseInt(limit),
        offset: parseInt(offset),
        order: [['createdAt', 'DESC']]
      });

      res.status(200).json({
        success: true,
        data: Auditorias.rows,
        pagination: {
          total: Auditorias.count,
          page: parseInt(page),
          limit: parseInt(limit),
          totalPages: Math.ceil(Auditorias.count / limit)
        }
      });
    } catch (error) {
      console.error('Error al obtener Auditoriaorías por usuario:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  },

  // Obtener Auditoriaorías por tabla
  getByTable: async (req, res) => {
    try {
      const { tableName } = req.params;
      const { page = 1, limit = 10 } = req.query;
      const offset = (page - 1) * limit;

      const Auditorias = await Auditoria.findAndCountAll({
        where: { Tabla: tableName },
        limit: parseInt(limit),
        offset: parseInt(offset),
        order: [['createdAt', 'DESC']]
      });

      res.status(200).json({
        success: true,
        data: Auditorias.rows,
        pagination: {
          total: Auditorias.count,
          page: parseInt(page),
          limit: parseInt(limit),
          totalPages: Math.ceil(Auditorias.count / limit)
        }
      });
    } catch (error) {
      console.error('Error al obtener Auditoriaorías por tabla:', error);
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        error: error.message
      });
    }
  }
};

module.exports = AuditoriaController;