const {Atiende} = require("../models");
const logger = require("../middlewares/logger.middleware");

// Obtener todas las Atiendees
exports.getAtiendeAll = async (req, res) => {
  try {
    const atiendes = await Atiende.findAll();
    logger.info("Atiendes obtenidos correctamente");
    res.json(atiendes);
  } catch (error) {
    logger.error("Error al obtener Atiendes: " + error.message);
    res.status(500).json({ error: "Error al obtener Atiendees" });
  }
};
// Obtener una Atiende por Odontologo
exports.getAtiendeByOdontologo = async (req, res) => {
  try {
    const { odontologo } = req.params;
    const atiendes = await Atiende.findAll(
      {
        where: {
          UsuarioId: odontologo
        }
      }
    );
    if (!atiendes) {
      logger.error("Atiende no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Atiendes no encontrada" });
    }
    logger.info("Atiendes obtenidas correctamente por su asociacion con la Empresa");
    res.json(atiendes);
  } catch (error) {
    logger.error("Error al obtener el Atiende mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Atiendes" });
  }
};
// Obtener una Atiende por Consultorio
exports.getAtiendeByConsultorio = async (req, res) => {
  try {
    const { consultorio } = req.params;
    const atiendes = await Atiende.findAll(
      {
        where: {
          ConsultorioId: consultorio
        }
      }
    );
    if (!atiendes) {
      logger.error("Atiende no encontrada por su asociacion con empresa");
      return res.status(404).json({ error: "Atiendes no encontrada" });
    }
    logger.info("Atiendes obtenidas correctamente por su asociacion con la Empresa");
    res.json(atiendes);
  } catch (error) {
    logger.error("Error al obtener el Atiende mediante por Empresa: " + error.message);
    res.status(500).json({ error: "Error al obtener Atiendes" });
  }
};

// Obtener una Atiende por ID
exports.getAtiendeById = async (req, res) => {
  try {
    const atiende = await Atiende.findByPk(req.params.id);
    if (!atiende) {
      logger.error("Atiende no encontrada por su ID");
      return res.status(404).json({ error: "Atiende no encontrada" });
    }
    logger.info("Atiende obtenido correctamente por su ID");
    res.json(atiende);
  } catch (error) {
    logger.error("Error al obtener el Atiende mediante su Id: " + error.message);
    res.status(500).json({ error: "Error al obtener Atiende" });
  }
};

// Crear una Atiende
exports.createAtiende = async (req, res) => {
  try {
    const atiende = await Atiende.create(req.body);
    logger.info("Atiendes creado correctamente");
    res.status(201).json(atiende);
  } catch (error) {
    logger.error("Error al crear un Atiende: " + error.message);
    res.status(500).json({ error: "Error al crear Atiende" });
  }
};

// Actualizar una Atiende
exports.updateAtiende = async (req, res) => {
  try {
    const atiende = await Atiende.findByPk(req.params.id);
    if (!atiende) {
      logger.error("Atiende no encontrada por su ID");
      return res.status(404).json({ error: "Atiende no encontrada" });
    }
    await atiende.update(req.body);
    logger.info("Atiendes actualizado correctamente");
    res.json(atiende);
  } catch (error) {
    logger.error("Error al actualizar un Atiende: " + error.message);
    res.status(500).json({ error: "Error al actualizar Atiende" });
  }
};

// Eliminar una Atiende
exports.deleteAtiende = async (req, res) => {
  try {
    const atiende = await Atiende.findByPk(req.params.id);
    if (!atiende) {
      logger.error("Atiende no encontrada por su ID");
      return res.status(404).json({ error: "Atiende no encontrada" });
    }
    await Atiende.destroy();
    logger.info("Atiendes eliminado correctamente");
    res.json({ message: "Atiende eliminada" });
  } catch (error) {
    logger.error("Error al elimininar un Atiende: " + error.message);
    res.status(500).json({ error: "Error al eliminar Atiende" });
  }
};

